﻿

//=================================================================
// Globals
//=================================================================

// UI strings to be localized 
var strButtonRun = localize("$$$/JavaScripts/ArtboardsToFiles/Run=Run");
var strButtonCancel = localize("$$$/JavaScripts/ArtboardsToFiles/Cancel=Cancel");
var strLabelDestination = localize("$$$/JavaScripts/ArtboardsToFiles/Destination=Destination:");
var strButtonBrowse = localize("$$$/JavaScripts/ArtboardsToFiles/Browse=&Browse...");
var strLabelFileNamePrefix = localize("$$$/JavaScripts/ArtboardsToFiles/FileNamePrefix=File Name Prefix:");
// export options for file types
var strLabelFileType = localize("$$$/JavaScripts/ArtboardsToFiles/FileType=File Type:");
var strCheckboxIncludeICCProfile = localize("$$$/JavaScripts/ArtboardsToFiles/IncludeICC=&Include ICC Profile");
var strJPEGOptions = localize("$$$/JavaScripts/ArtboardsToFiles/JPEGOptions=JPEG Options:");
var strLabelQuality = localize("$$$/JavaScripts/ArtboardsToFiles/Quality=Quality:");
var strPSDOptions = localize("$$$/JavaScripts/ArtboardsToFiles/PSDOptions=PSD Options:");
var strCheckboxMaximizeCompatibility = localize("$$$/JavaScripts/ArtboardsToFiles/Maximize=&Maximize Compatibility");
var strTIFFOptions = localize("$$$/JavaScripts/ArtboardsToFiles/TIFFOptions=TIFF Options:");
var strLabelImageCompression = localize("$$$/JavaScripts/ArtboardsToFiles/ImageCompression=Image Compression:");
var strNone = localize("$$$/JavaScripts/ArtboardsToFiles/None=None");
    var strCheckboxPreserveArtboard = localize("$$$/JavaScripts/ArtboardsToFiles/PreserveArtboard=Preserve Artboard");
var strPDFOptions = localize("$$$/JavaScripts/ArtboardsToFiles/PDFOptions=PDF Options:");
var strLabelEncoding = localize("$$$/JavaScripts/ArtboardsToFiles/Encoding=Encoding:");
var strTargaOptions = localize("$$$/JavaScripts/ArtboardsToFiles/TargaOptions=Targa Options:");
var strLabelDepth = localize("$$$/JavaScripts/ArtboardsToFiles/Depth=Depth:");
var strRadiobutton16bit = localize("$$$/JavaScripts/ArtboardsToFiles/Bit16=16bit");
var strRadiobutton24bit = localize("$$$/JavaScripts/ArtboardsToFiles/Bit24=24bit");
var strRadiobutton32bit = localize("$$$/JavaScripts/ArtboardsToFiles/Bit32=32bit");
var strBMPOptions = localize("$$$/JavaScripts/ArtboardsToFiles/BMPOptions=BMP Options:");
var strAlertDestinationNotExist = localize("$$$/JavaScripts/ArtboardsToFiles/DestionationDoesNotExist=Destination does not exist.");
var strUnexpectedError = localize("$$$/JavaScripts/ArtboardsToFiles/Unexpected=Unexpected error");
var stretQuality = localize( "$$$/locale_specific/JavaScripts/ArtboardsToFiles/ETQualityLength=30" );
var stretDestination = localize( "$$$/locale_specific/JavaScripts/ArtboardsToFiles/ETDestinationLength=160" );
var strddFileType = localize( "$$$/locale_specific/JavaScripts/ArtboardsToFiles/DDFileType=100" );
var strpnlOptions = localize( "$$$/locale_specific/JavaScripts/ArtboardsToFiles/PNLOptions=100" );
var strPNG8Options = localize("$$$/JavaScripts/ArtboardsToFiles/PNG8Options=PNG-8 Options:");
var strCheckboxPNGTransparency = localize("$$$/JavaScripts/ArtboardsToFiles/Transparency=Transparency");
var strCheckboxPNGInterlaced = localize("$$$/JavaScripts/ArtboardsToFiles/Interlaced=Interlaced");
//var strCheckboxPNGTrm = localize("$$$/JavaScripts/ArtboardsToFiles/Trim=Trim Layers");
var strPNG24Options = localize("$$$/JavaScripts/ArtboardsToFiles/PNG24Options=PNG-24 Options:");
var strCheckboxSelectionOnly = localize("$$$/JavaScripts/ArtboardsToFiles/Selected=&Export Selected Artboards");
var strCheckboxSelectedOverlaping = localize("$$$/JavaScripts/ArtboardsToFiles/SelectedOverlaping=&Include Overlapping Areas");
var strCheckboxContentOnly = localize("$$$/JavaScripts/ArtboardsToFiles/SelectedContent=&Artboard Content Only");
var strAlertSpecifyDestination = localize("$$$/JavaScripts/ArtboardsToFiles/SpecifyDestination=Please specify destination.");
var strTitleSelectDestination = localize("$$$/JavaScripts/ArtboardsToFiles/SelectDestination=Select Destination");
var strAlertDocumentMustBeOpened = localize("$$$/JavaScripts/ArtboardsToFiles/OneDocument=You must have a document open to export.");
var strAlertNoArtboardsFound = localize("$$$/JavaScripts/ArtboardsToFiles/Noartbrd=No artboards found in document.");
var strAlertWasSuccessful = localize("$$$/JavaScripts/ArtboardsToFiles/Success= was successful.");
var strAlertFailed = localize("$$$/JavaScripts/ArtboardsToFiles/Fail= failed.");
var strAlertNoArtboardsSelected= localize("$$$/JavaScripts/ArtboardsToFiles/Noartbrdsel=Selected layer was not an artboard.");

var strShowSaveOptions= localize("$$$/JavaScripts/ArtboardsToFiles/ExportOptions= Export Options");
var strMultiPageDoc= localize("$$$/JavaScripts/ArtboardsToFiles/MultiPageDoc= Multi-Page Document");
var strDocPerArtboard= localize("$$$/JavaScripts/ArtboardsToFiles/DocPerArtboard= Document Per Artboard");
var strIncludeFileName= localize("$$$/JavaScripts/ArtboardsToFiles/IncludeFileName= Include File Name");

 // make sure all calcualtions are done in pixels. 
  var ru= app.preferences.rulerUnits;
 app.preferences.rulerUnits = Units.PIXELS;
 
// the drop down list indexes for file type
var bmpIndex = 0; 
var jpegIndex = 1;
var pdfIndex = 2;
var psdIndex = 3;
var targaIndex = 4;
var tiffIndex = 5;
var png8Index = 6; 
var png24Index = 7;

// the drop down list indexes for tiff compression
var compNoneIndex = 0;
var compLZWIndex = 1;
var compZIPIndex = 2;
var compJPEGIndex = 3;

// ok and cancel button
var runButtonID = 1;
var cancelButtonID = 2;


///////////////////////////////////////////////////////////////////////////////
// Function: main
// Usage: the main routine for this JavaScript
// Input: initialization data for UI, and string that identifies which menuItem was selected to run this script. 
// Return: <none>
///////////////////////////////////////////////////////////////////////////////
function main(initExportInfo, type)
{

   // Check if there is an active document.       
    if ( app.documents.length <= 0 ) {
        if ( DialogModes.NO != app.playbackDisplayDialogs ) {
            alert( strAlertDocumentMustBeOpened );
        }
                return 'cancel'; // quit, returning 'cancel' (dont localize) makes the actions palette not record our script
    }
 
    var origDoc = app.activeDocument;
    var sel_indxs = getSelectedLayersAMIdx(origDoc);
    // check to see if selected layers are artboards have artboardID. 
    var abArSelected = getArtBoards(sel_indxs);
        if ( abArSelected.length === 0 ) 
        {  
            var isSelection = false;
        } else { 
            var isSelection = true;
        }
    
    var exportInfo = new Object();
    initExportInfo(exportInfo, isSelection, false);

    
     // look for last used params via Photoshop registry, getCustomOptions will throw if none exist
	try {
        // this will replace ALL the elements of the UI with the last saved settings.  ALL OF THEM! 
        if (running == "abToPDF")  var d = app.getCustomOptions("12fb03a7-e9af-426a-8377-3d423d7303e6"); 
		if (running == "abToFiles")  var d = app.getCustomOptions("ffcb20ee-4c1f-11e5-885d-feff819cdc9f"); 
  		descriptorToObject(exportInfo, d, strMessage, postProcessExportInfo);  //< dont' need to post process anything... but keeping it in there as an example. 
	}
	catch(e) {
		// it's ok if we don't have any options, continue with defaults
	}

    // see if I am getting descriptor parameters
    descriptorToObject(exportInfo, app.playbackParameters, strMessage, postProcessExportInfo);
             
  // RUN THE DIALOG!   (if dialog setting is on - in case running through recorded action.) 
   if ( DialogModes.NO != app.playbackDisplayDialogs ) 
   {
       
               // adding anything else here that I do NOT want to be sticky,  like the other export options that are not file based. 
              initExportInfo(exportInfo, isSelection, true);
         	initFileNameDestination(exportInfo);

    
        if (cancelButtonID == settingDialog(exportInfo, isSelection)) 
        {
	    	return 'cancel'; // quit, returning 'cancel' (dont localize) makes the actions palette not record our script
	    }
    }
            
try {
            var rememberMaximize;
            var needMaximize = exportInfo.psdMaxComp ? QueryStateType.ALWAYS : QueryStateType.NEVER;
            if ( exportInfo.fileType == psdIndex && app.preferences.maximizeCompatibility != needMaximize ) {
                rememberMaximize = app.preferences.maximizeCompatibility;
                app.preferences.maximizeCompatibility = needMaximize;
            }

            if (exportInfo.selectionOnly)  
            { 
                // abArSelected is defined already above.  UI will not alow to export selected if there are no Artboardd selected. on execute.  
                // *FOR REFERENEC ONLY * var sel_indxs = getSelectedLayersAMIdx(origDoc); var abArSelected = getArtBoards(sel_indxs);
            }
        
            if (!exportInfo.selectionOnly)  
            { 
                // if selected is false, then the ones selected are ALL of them.
                abArSelected = getABLayerInfo(); 
            }
 
           if (exportInfo.includeOverlaping)
            {
                   var abArALL  = getABLayerInfo(); 
                    if (!exportInfo.selectionOnly)   abAr = abArALL; 
                    if (exportInfo.selectionOnly)    abAr = abArSelected; 
            }
                
            // if I am  just grouping each artboard seperately, then no need to unarbard.
            if ( exportInfo.contentOnly )
            {      
                abAr = abArSelected;   // dosen't have the group yet, but thats ok. 
             }   
    
      // DO IT!   
            var artbrdCount = abAr.length;
            var exportFileCount = 0;
             for ( artbrdIndex = 0; artbrdIndex < artbrdCount; artbrdIndex++ )
            {
                
                if (!exportInfo.contentOnly )
                {
                    // duplicate the duped doc, because this is the one I'm going to clean crop, save, and close.  
                    var abDoc = origDoc.duplicate();   // do all work on duplicate document so original is not touched.   
                    app.activeDocument = abDoc;
                    // turn off UI settings. 
                    setEnabled("autoNestEnabled", false)  ; // to prevent layer from popping into other layersets unexpedly while script is running 
                    setEnabled("autoPositionEnabled", false);  // to prevent layers from moving in the document space coordinates
                    setEnabled("autoExpandEnabled", false) ;// in case there is an empty ab, if the empty AB gets removed, the document will resize and all the coordinates get off. 
                    
                    // clean up the artboard removing non overlaping artboards. 
                    cleanUnseenAB(abAr[artbrdIndex].AMid, abArALL);
                    var abAMid = abAr[artbrdIndex].AMid;
                    var abArrUpdated = getABLayerInfo(); 
                    var abArrUpdatedGr = unArtBoard(abArrUpdated, abDoc);    //new property abAr[0].groupAMid   created 
                     selectAbByOldID(abAMid,abArrUpdatedGr)
                }

                // if I'm NOT considering the entier document, only the artboard contents then 
                if (exportInfo.contentOnly )
                {
                        // I duplicate just the artboard to a new doc, and unartboard it there.. 
                        selectLayerFromAMid(abAr[artbrdIndex].AMid, "'addToSelection"); 
                        artboardDuplToNewDoc(abAr[artbrdIndex].name); 
                        var abDoc = app.activeDocument; 
                        var abInfo = getABLayerInfo();
                        unArtBoard(abInfo, abDoc);
                } 
               
                cropFromMask();
                removeEmptyLayers(abDoc);
    
                // if export type is photoshop file, and option to preserve artboard  is true
                 if ((exportInfo.fileType == psdIndex ) && (exportInfo.preserveArtboard) ) 
                 {
                     reArtboard(abDoc, abAr[artbrdIndex].name);
                  }  

                exportDoc(abAr, artbrdIndex, abDoc, exportInfo);
                abDoc.close(SaveOptions.DONOTSAVECHANGES);

                app.activeDocument = origDoc;
                exportFileCount++;
            }
        
            // if multi page PDF was selected, then  create it and cleanup temp files. 
            if ((exportInfo.fileType == pdfIndex ) && (exportInfo.multipage) ) 
           {
                createMultiPagePDF(exportInfo, origDoc, abAr );
            }

            // if I reach this point, then I need to save those UI settings so they are stickly. 
             var d = objectToDescriptor(exportInfo, strMessage, preProcessExportInfo);  // get the object values from the UI and put them into the ACtionDescriptor that PS can store into the custom options. 
            app.putCustomOptions("e6a88a1c-4c14-11e5-885d-feff819cdc9f", d);  // store the descriptor into the custom options
            if (running == "abToPDF")  app.putCustomOptions("db7aceec-4c1f-11e5-885d-feff819cdc9f", d); 
            if (running == "abToFiles")  app.putCustomOptions("ffcb20ee-4c1f-11e5-885d-feff819cdc9f", d);
            
        logToHeadLights(strTitle + " file count: " + exportFileCount )
         
             if ( DialogModes.ALL == app.playbackDisplayDialogs ) 
             {                
                alert(strTitle + strAlertWasSuccessful + "\n" + exportInfo.destination);
             }
            app.playbackDisplayDialogs = DialogModes.ALL;
        
    } catch (e) {
           // clean up open duplicates if open after error. 
            try { srcDoc.close(SaveOptions.DONOTSAVECHANGES); } catch(e){}
            try { abDoc.close(SaveOptions.DONOTSAVECHANGES); } catch(e){}
            
            if ( DialogModes.NO != app.playbackDisplayDialogs ) { alert(e); }
         return 'cancel'; // quit, returning 'cancel' (dont localize) makes the actions palette not record our script
    }
}


function reArtboard(abDoc, abArName)
{
    createSolidColorLayer(255, 255, 255);
    // get the colorFill Layer ID and make that the first in the layer ID list. 
    var allLayIDs = [getLayerID()];
    // move to bottom of the document
    abDoc.activeLayer.move(abDoc.layers[abDoc.layers.length -1],ElementPlacement.PLACEAFTER);
    // continuus selection too slow if lots of layers, so just add the ID's for all the top level layersets. 
    for (i=0;i<abDoc.layers.length-1; i++) 
    {
        abDoc.activeLayer = abDoc.layers[i];
        allLayIDs.push(getLayerID());
    } 
    // and then select all of those. 
    for (x=0;x<allLayIDs.length-1; x++) 
    {
        selectLayerFromAMid(allLayIDs[x],"addToSelection");
    } 
    // run Artboard from layers.  name artboard same as selected. 
     artboardFromLayers(abArName);
     // remove colorFillLayer (I know this is the first in the list.) 
     deleteByID(allLayIDs[0]);
 }


///////////////////////////////////////////////////////////////////////////////
// Function: exportDoc
// Usage: sets up the file name to be exported via the saveFileNow function. 
// Input: ArtboardDataArray, indexofArtboard curretnly getting executed against, document to save, and UI info
// Return: none
///////////////////////////////////////////////////////////////////////////////
function exportDoc(abAr, artbrdIndex, abDoc, exportInfo) 
{    
        var fileNameBody = exportInfo.fileNamePrefix;
        fileNameBody += abAr[artbrdIndex].name;
        fileNameBody = fileNameBody.replace(/[:\/\\*\?\"\<\>\|]/g, "_");  // '/\:*?"<>|' -> '_'
        if (fileNameBody.length > 120) 
        {
			fileNameBody = fileNameBody.substring(0,120);
		}
        
        saveFileNow(abDoc, fileNameBody, exportInfo);
}


///////////////////////////////////////////////////////////////////////////////
// Function: createMultiPagePDF
// Usage: run the PDF presetation C++ plugin with settings 
// Input: UI informtation
// Return: none.  
///////////////////////////////////////////////////////////////////////////////
function createMultiPagePDF(exportInfo, origDoc, abAr ) 
{
    // run PDF presentation if multipage is selected.        
        var tempPSDs = (exportInfo.destination + "/TempPSDs");
        var PDFname = exportInfo.fileNamePrefix;
        
        if (PDFname.length == 0 ) 
        {
            var tmp = origDoc.fullName.name;
            PDFname = decodeURI(tmp.substring(0, tmp.indexOf("."))); // filename body part
        }

        var saveFile = new File(exportInfo.destination + "/" + PDFname + ".pdf");
        var filesinTemp = Folder(tempPSDs).getFiles(); 

        // sort the files comming in to make the multipage PDF so they are in the same order as the original document. 
        var sortedFileList = sortFilesPerSrcDoc(filesinTemp,abAr, exportInfo.fileNamePrefix);

        pdfSaveOptions = new PDFSaveOptions();
        pdfSaveOptions.embedColorProfile = exportInfo.iccPDF;
        pdfSaveOptions.encoding = exportInfo.pdfEncoding;
        if (PDFEncoding.JPEG == exportInfo.pdfEncoding) 
        {
            pdfSaveOptions.jpegQuality = exportInfo.pdfJpegQuality;
        }

        // run PDF Presentation
        var presentationOptions = new PresentationOptions();
        presentationOptions.presentation = false;
        presentationOptions.view = true;
        presentationOptions.PDFFileOptions = pdfSaveOptions; 
        presentationOptions.includeFilename = exportInfo.inclFilename;
        app.makePDFPresentation(sortedFileList, saveFile, presentationOptions);

      // clean up temp files. 
            for (i=0;i<sortedFileList.length;i++) { File(sortedFileList[i]).remove(); }
            Folder(tempPSDs).remove();    
}


function sortFilesPerSrcDoc(filesinTemp, abAr, PDFname)
{
    var sortedFileList = [];
            if (PDFname.length == 0 ) {PDFname = ""; }
    
    for (var x=0;x<abAr.length;x++)
    {
            for (var y=0;y<filesinTemp.length;y++)
            {
                    if (filesinTemp[y].name == encodeURI(PDFname + abAr[x].name + ".psd"))
                    {
                             sortedFileList.push(filesinTemp[y]);
                     }
             }
    }
        // because some characters are having encoding issues,  I have added this line just in case. 
    if (sortedFileList.length == 0 ) sortedFileList = filesinTemp;
    return sortedFileList.reverse()
 }


///////////////////////////////////////////////////////////////////////////////
// Function: selectAbByOldID
// Usage:  Shortcut to match an old AMid value with a new GroupID value in an array of artboard data. 
// Input: AM id of a layer, and array of artboard layer data. 
// Return: none (selects artboard with new groupAMID) 
///////////////////////////////////////////////////////////////////////////////
function selectAbByOldID(origabAMid,newAbArr)
{
    for (a=0;a<newAbArr.length;a++) 
    {
        if (newAbArr[a].AMid == origabAMid)
        {
           selectLayerFromAMid(newAbArr[a].groupAMid, "'addToSelection"); 
         }
     } 
 } 


///////////////////////////////////////////////////////////////////////////////
// Function: settingDialog
// Usage: pop the ui and get user settings
// Input: exportInfo object containing our parameters
// Return: on ok, the dialog info is set to the exportInfo object
///////////////////////////////////////////////////////////////////////////////
function settingDialog(exportInfo) {
    var dlgMain = new Window("dialog", strTitle);
    
	// match our dialog background color to the host application
	var brush = dlgMain.graphics.newBrush (dlgMain.graphics.BrushType.THEME_COLOR, "appDialogBackground");
    dlgMain.graphics.backgroundColor = brush;
    dlgMain.graphics.disabledBackgroundColor = dlgMain.graphics.backgroundColor;

	dlgMain.orientation = 'column';
	dlgMain.alignChildren = 'center';
	dlgMain.spacing = 10;
        
	// -- top of the dialog, first line
    var desttext = dlgMain.add("statictext", undefined, strLabelDestination);
    desttext.alignment = 'left';

	// -- two groups, one for left and one for right ok, cancel
	dlgMain.grpTop = dlgMain.add("group", undefined);
	dlgMain.grpTop.orientation = 'column';
	dlgMain.grpTop.alignChildren = 'top';
    dlgMain.grpTop.alignment = 'fill';


	// -- group top left 
	dlgMain.grpTopLeft = dlgMain.grpTop.add("group");
	dlgMain.grpTopLeft.orientation = 'column';
	dlgMain.grpTopLeft.alignChildren = 'left';
	dlgMain.grpTopLeft.alignment = 'fill';
	
	// -- the second line in the dialog
	dlgMain.grpSecondLine = dlgMain.grpTopLeft.add("group");
	dlgMain.grpSecondLine.orientation = 'row';
	dlgMain.grpSecondLine.alignChildren = 'center';
    
    dlgMain.etDestination = dlgMain.grpSecondLine.add("edittext", undefined, exportInfo.destination.toString());
    dlgMain.etDestination.preferredSize = [300,25];

    dlgMain.btnBrowse = dlgMain.grpSecondLine.add("button", undefined, strButtonBrowse);
    dlgMain.btnBrowse.onClick = function() {
		var defaultFolder = dlgMain.etDestination.text;
		var testFolder = new Folder(dlgMain.etDestination.text);
		if (!testFolder.exists) {
			defaultFolder = "~";
		}
		var selFolder = Folder.selectDialog(strTitleSelectDestination, defaultFolder);
		if ( selFolder != null ) {
	        dlgMain.etDestination.text = selFolder.fsName;
	    }
		dlgMain.defaultElement.active = true;
	}

	// -- the third line in the dialog
    dlgMain.grpTopLeft.add("statictext", undefined, strLabelFileNamePrefix);

	// File Name prefix. 
    dlgMain.etFileNamePrefix = dlgMain.grpTopLeft.add("edittext", undefined, exportInfo.fileNamePrefix.toString());
    dlgMain.etFileNamePrefix.alignment = 'fill';
   dlgMain.etFileNamePrefix.preferredSize = [300,25];
    
	// -- Export options
    dlgMain.cbSelOptionsGrp = dlgMain.grpTopLeft.add("group");
    dlgMain.cbSelOptionsGrp.orientation = "column";
    dlgMain.cbSelOptionsGrp.alignment = 'left' ;
    
     dlgMain.cbOverlaping= dlgMain.cbSelOptionsGrp.add("radiobutton", undefined, strCheckboxSelectedOverlaping);
    dlgMain.cbOverlaping.value = exportInfo.includeOverlaping;
    dlgMain.cbOverlaping.alignment = 'left';
    
    dlgMain.cbContentOnly = dlgMain.cbSelOptionsGrp.add("radiobutton", undefined, strCheckboxContentOnly);
    dlgMain.cbContentOnly.value = exportInfo.contentOnly;
    dlgMain.cbContentOnly.alignment = 'left';    
    
    dlgMain.cbSelection = dlgMain.grpTopLeft.add("checkbox", undefined, strCheckboxSelectionOnly);
    dlgMain.cbSelection.value = exportInfo.selectionOnly;
    dlgMain.cbSelection.enabled = exportInfo.selectionOnly;

	// -- the sixth line is the panel
    //dlgMain.pnlFileType = dlgMain.grpTopLeft.add("panel", undefined, strLabelFileType);
    dlgMain.pnlFileType = dlgMain.grpTopLeft.add("group");
	dlgMain.pnlFileType.alignment = 'fill';
    dlgMain.pnlFileType.orientation = 'column';
    
    // -- now a dropdown list
    dlgMain.ddFileTypeGr = dlgMain.pnlFileType.add("group");
    dlgMain.ddFileTypeGr.alignment = 'left';
    dlgMain.ddFileTypeGr .orientation = "row";
    dlgMain.ddFileType = dlgMain.ddFileTypeGr.add("statictext", undefined, strLabelFileType);
    dlgMain.ddFileType = dlgMain.ddFileTypeGr.add("dropdownlist");
    dlgMain.ddFileType.preferredSize.width = StrToIntWithDefault( strddFileType, 100 );
    
     if (!exportInfo.showExpTypes) dlgMain.ddFileTypeGr.hide();

    dlgMain.ddFileType.add("item", "BMP");
    dlgMain.ddFileType.add("item", "JPEG");
    dlgMain.ddFileType.add("item", "PDF");
	dlgMain.ddFileType.add("item", "PSD");
    dlgMain.ddFileType.add("item", "Targa");
    dlgMain.ddFileType.add("item", "TIFF");
    dlgMain.ddFileType.add("item", "PNG-8");
    dlgMain.ddFileType.add("item", "PNG-24");  
    dlgMain.ddFileType.items[exportInfo.fileType].selected = true;

    dlgMain.pnlOptionsShow = dlgMain.ddFileTypeGr.add("checkbox", undefined, strShowSaveOptions); 
    //dlgMain.pnlOptionsShow.alignment = 'left';

         
	// -- now the options panel that changes
    dlgMain.pnlFileType.pnlOptions = dlgMain.pnlFileType.add("panel", undefined, "Options");
    dlgMain.pnlFileType.pnlOptions.alignment = 'fill';
    dlgMain.pnlFileType.pnlOptions.orientation = 'stack';
    dlgMain.pnlFileType.pnlOptions.preferredSize.height = StrToIntWithDefault( strpnlOptions, 100 );




	// PDF options
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions = dlgMain.pnlFileType.pnlOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.orientation = 'column';
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.margins = 10;
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.visible = (exportInfo.fileType == pdfIndex);

    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.alignment = 'left';
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.spacing = 10;
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.orientation = 'column';
    
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.pageType =  dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.add("group");
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.pageType.orientation = 'row';
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.pageType.alignChildren = 'left';
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.multipage = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.pageType.add("radiobutton", undefined, strMultiPageDoc); 
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.multipage.value = exportInfo.multipage; 
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.singlepage = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.pageType.add("radiobutton", undefined, strDocPerArtboard); 
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.singlepage.value = exportInfo.singlepage; 

    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.chincludeName = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.add("checkbox", undefined,strIncludeFileName); 
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.chincludeName.alignment = "left"
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.chincludeName.value = exportInfo.inclFilename; 
   
   // sets the includeName field to be disabled if single page option is on. 
    if(exportInfo.singlepage)
    {
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.chincludeName.enabled = false; 
    }

 // if multipage is selected 
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.multipage.onClick = function() 
        {
         if ( dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.multipage.value) 
         { 
             dlgMain.pnlFileType.pnlOptions.grpPDFOptions.chincludeName.enabled = true; 
          } 
    
             if (!dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.multipage.value) 
         { 
             dlgMain.pnlFileType.pnlOptions.grpPDFOptions.chincludeName.value = false;
             dlgMain.pnlFileType.pnlOptions.grpPDFOptions.chincludeName.enabled = false; 
          } 

        }

// if singlepage is selected  See below...  

    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.alignment = 'left';
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.add("statictext", undefined, strLabelEncoding);
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.rbZip = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.add("radiobutton", undefined, "ZIP");
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.rbZip.onClick = function() 
    {
		dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.stQuality.enabled = false;   
		dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.etQuality.enabled = false;   
	}


    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.rbJpeg = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.add("radiobutton", undefined, "JPEG");
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.rbJpeg.onClick = function() 
    {
		dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.stQuality.enabled = true;   
		dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.etQuality.enabled = true;   
	}
	
	dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.add("group");
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.spacing = 5;
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.stQuality = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.add("statictext", undefined, strLabelQuality);
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.etQuality = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.add("edittext", undefined, exportInfo.pdfJpegQuality.toString());
    dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.etQuality.preferredSize.width = StrToIntWithDefault( stretQuality, 30 );


     // if singlePage is selected
   dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.singlepage.onClick = function() 
 {

         if ( dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.singlepage.value) 
         { 
              dlgMain.pnlFileType.pnlOptions.grpPDFOptions.chincludeName.value = false;
              dlgMain.pnlFileType.pnlOptions.grpPDFOptions.chincludeName.enabled = false; 
          } 
  }




    dlgMain.cbIccPDF = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.add("checkbox", undefined, strCheckboxIncludeICCProfile);
    dlgMain.cbIccPDF.value = exportInfo.iccPDF;
    dlgMain.cbIccPDF.alignment = 'left';
	dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.etQuality.graphics.disabledBackgroundColor = brush;

    switch (exportInfo.pdfEncoding) {
        case PDFEncoding.PDFZIP: 
			dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.rbZip.value  = true;    break;
        case PDFEncoding.JPEG:
        default: 
			dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.rbJpeg.value = true;    break;
    }
    
    if (PDFEncoding.JPEG != exportInfo.pdfEncoding) {
        dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.stQuality.enabled = false;
        dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.etQuality.enabled = false;
    }


    
	// PSD options
    dlgMain.pnlFileType.pnlOptions.grpPSDOptions = dlgMain.pnlFileType.pnlOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpPSDOptions.orientation = "column" 
         dlgMain.pnlFileType.pnlOptions.grpPSDOptions.alignChildren  = "left" ; 
         
    dlgMain.pnlFileType.pnlOptions.grpPSDOptions.cbMax = dlgMain.pnlFileType.pnlOptions.grpPSDOptions.add("checkbox", undefined, strCheckboxMaximizeCompatibility);
    dlgMain.preserveArtboard = dlgMain.pnlFileType.pnlOptions.grpPSDOptions.add("checkbox", undefined, strCheckboxPreserveArtboard );  
    dlgMain.preserveArtboard.value = exportInfo.preserveArtboard;
    
    dlgMain.cbIccPSD = dlgMain.pnlFileType.pnlOptions.grpPSDOptions.add("checkbox", undefined, strCheckboxIncludeICCProfile);
    dlgMain.cbIccPSD.value = exportInfo.iccPSD;
    dlgMain.pnlFileType.pnlOptions.grpPSDOptions.cbMax.value = exportInfo.psdMaxComp;
    dlgMain.pnlFileType.pnlOptions.grpPSDOptions.visible = (exportInfo.fileType == psdIndex);

     // PNG8 options
    dlgMain.pnlFileType.pnlOptions.grpPNG8Options = dlgMain.pnlFileType.pnlOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpPNG8Options.orientation = "column" 
    
    dlgMain.pnlFileType.pnlOptions.grpPNG8TranOptions = dlgMain.pnlFileType.pnlOptions.grpPNG8Options.add("group");
    dlgMain.pnlFileType.pnlOptions.grpPNG8Options.png8Trans = dlgMain.pnlFileType.pnlOptions.grpPNG8TranOptions.add("checkbox", undefined, strCheckboxPNGTransparency.toString());
    dlgMain.pnlFileType.pnlOptions.grpPNG8Options.png8Inter = dlgMain.pnlFileType.pnlOptions.grpPNG8TranOptions.add("checkbox", undefined, strCheckboxPNGInterlaced.toString());
    dlgMain.pnlFileType.pnlOptions.grpPNG8Options.png8Trans.value = exportInfo.png8Transparency;
    dlgMain.pnlFileType.pnlOptions.grpPNG8Options.png8Inter.value = exportInfo.png8Interlaced;  
    
    dlgMain.pnlFileType.pnlOptions.grpPNG8IccOptions = dlgMain.pnlFileType.pnlOptions.grpPNG8Options.add("group");
    dlgMain.cbIccPNG8 = dlgMain.pnlFileType.pnlOptions.grpPNG8IccOptions.add("checkbox", undefined, strCheckboxIncludeICCProfile);
    dlgMain.cbIccPNG8.value = exportInfo.iccPNG8;
    dlgMain.pnlFileType.pnlOptions.grpPNG8Options.visible = (exportInfo.fileType == png8Index);
    
    // PNG24 options
    dlgMain.pnlFileType.pnlOptions.grpPNG24Options = dlgMain.pnlFileType.pnlOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpPNG24Options.orientation = "column" 
    
    dlgMain.pnlFileType.pnlOptions.grpPNG24TranOptions = dlgMain.pnlFileType.pnlOptions.grpPNG24Options.add("group");
    dlgMain.pnlFileType.pnlOptions.grpPNG24Options.png24Trans = dlgMain.pnlFileType.pnlOptions.grpPNG24TranOptions.add("checkbox", undefined, strCheckboxPNGTransparency.toString());
    dlgMain.pnlFileType.pnlOptions.grpPNG24Options.png24Inter = dlgMain.pnlFileType.pnlOptions.grpPNG24TranOptions.add("checkbox", undefined, strCheckboxPNGInterlaced.toString());
    dlgMain.pnlFileType.pnlOptions.grpPNG24Options.png24Trans.value = exportInfo.png24Transparency;
    dlgMain.pnlFileType.pnlOptions.grpPNG24Options.png24Inter.value = exportInfo.png24Interlaced;  
    
    dlgMain.pnlFileType.pnlOptions.grpPNG24IccOptions = dlgMain.pnlFileType.pnlOptions.grpPNG24Options.add("group");
    dlgMain.cbIccPNG24 = dlgMain.pnlFileType.pnlOptions.grpPNG24IccOptions.add("checkbox", undefined, strCheckboxIncludeICCProfile);
    dlgMain.cbIccPNG24.value = exportInfo.iccPNG24;
    dlgMain.pnlFileType.pnlOptions.grpPNG24Options.visible = (exportInfo.fileType == png8Index);

	// JPEG options
    dlgMain.pnlFileType.pnlOptions.grpJPEGOptions = dlgMain.pnlFileType.pnlOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpJPEGOptions.orientation = "column";     
    dlgMain.pnlFileType.pnlOptions.grpJPEGQualOptions = dlgMain.pnlFileType.pnlOptions.grpJPEGOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpJPEGQualOptions.orientation = "row";    
    dlgMain.pnlFileType.pnlOptions.grpJPEGQualOptions.add("statictext", undefined, strLabelQuality);
    dlgMain.pnlFileType.pnlOptions.grpJPEGOptions.etQuality = dlgMain.pnlFileType.pnlOptions.grpJPEGQualOptions.add("edittext", undefined, exportInfo.jpegQuality.toString());
    dlgMain.pnlFileType.pnlOptions.grpJPEGOptions.etQuality.preferredSize.width = StrToIntWithDefault( stretQuality, 30 );
    
    dlgMain.pnlFileType.pnlOptions.grpJPEGIccOptions = dlgMain.pnlFileType.pnlOptions.grpJPEGOptions.add("group");
    dlgMain.cbIccJPG = dlgMain.pnlFileType.pnlOptions.grpJPEGIccOptions.add("checkbox", undefined, strCheckboxIncludeICCProfile);
    dlgMain.cbIccJPG.value = exportInfo.iccJPG;
    
    dlgMain.pnlFileType.pnlOptions.grpJPEGOptions.visible = (exportInfo.fileType == jpegIndex);

	// TIFF options
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions = dlgMain.pnlFileType.pnlOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.orientation = 'column';
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.visible = (exportInfo.fileType == tiffIndex);
    
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression = dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.alignment = 'left';
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.add("statictext", undefined, strLabelImageCompression);
    

    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.ddCompression = dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.add("dropdownlist");
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.ddCompression.add("item", strNone);
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.ddCompression.add("item", "LZW");
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.ddCompression.add("item", "ZIP");
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.ddCompression.add("item", "JPEG");
    
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.ddCompression.onChange = function() {
		if (this.selection.index == compJPEGIndex) {
			dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.stQuality.enabled = true;
			dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.etQuality.enabled = true;
		} else {
			dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.stQuality.enabled = false;
			dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.etQuality.enabled = false;
		}
    }

	dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality = dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.alignment = 'left';
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.stQuality = dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.add("statictext", undefined, strLabelQuality);
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.etQuality = dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.add("edittext", undefined, exportInfo.tiffJpegQuality.toString());
    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.etQuality.preferredSize.width = StrToIntWithDefault( stretQuality, 30 );
	dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.etQuality.graphics.disabledBackgroundColor = brush;
    
	var index;
    switch (exportInfo.tiffCompression) {
		case TIFFEncoding.NONE:     index = compNoneIndex; break;
        case TIFFEncoding.TIFFLZW:  index = compLZWIndex; break;
        case TIFFEncoding.TIFFZIP:  index = compZIPIndex; break;
        case TIFFEncoding.JPEG:     index = compJPEGIndex; break;
        default: index = compNoneIndex;    break;
    }

    dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.ddCompression.items[index].selected = true;

	if (TIFFEncoding.JPEG != exportInfo.tiffCompression) { // if not JPEG
		dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.stQuality.enabled = false;
		dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.etQuality.enabled = false;
    }
    dlgMain.cbIccTIF = dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.add("checkbox", undefined, strCheckboxIncludeICCProfile);
    dlgMain.cbIccTIF.alignment = 'left';
    dlgMain.cbIccTIF.value = exportInfo.iccTIF;
    

	// Targa options
    
    dlgMain.pnlFileType.pnlOptions.grpTargaOptions = dlgMain.pnlFileType.pnlOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpTargaOptions.orientation = "column"; 
    dlgMain.pnlFileType.pnlOptions.grpTargaOptions.visible = (exportInfo.fileType == targaIndex);
    
    dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb16bitGr = dlgMain.pnlFileType.pnlOptions.grpTargaOptions.add("group"); 
    dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb16bitGr.orientation = "row"; 
    dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb16bitGr.add("statictext", undefined, strLabelDepth);
    dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb16bit = dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb16bitGr.add( "radiobutton", undefined, strRadiobutton16bit);
    dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb24bit = dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb16bitGr.add( "radiobutton", undefined, strRadiobutton24bit);
    dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb32bit = dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb16bitGr.add( "radiobutton", undefined, strRadiobutton32bit);

    dlgMain.pnlFileType.pnlOptions.grpTargaOptionsIccGr = dlgMain.pnlFileType.pnlOptions.grpTargaOptions.add("group");
    dlgMain.cbIccTGA = dlgMain.pnlFileType.pnlOptions.grpTargaOptionsIccGr.add("checkbox", undefined, strCheckboxIncludeICCProfile);
    dlgMain.cbIccTGA.value = exportInfo.iccTGA;
    
    switch (exportInfo.targaDepth) {
        case TargaBitsPerPixels.SIXTEEN:     dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb16bit.value = true;   break;
        case TargaBitsPerPixels.TWENTYFOUR:  dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb24bit.value = true;   break;
        case TargaBitsPerPixels.THIRTYTWO:   dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb32bit.value = true;   break;
        default: dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb24bit.value = true;   break;
    }


	// BMP options

    dlgMain.pnlFileType.pnlOptions.grpBMPOptions = dlgMain.pnlFileType.pnlOptions.add("group");
    dlgMain.pnlFileType.pnlOptions.grpBMPOptions.orientation = "column"; 
    dlgMain.pnlFileType.pnlOptions.grpBMPOptions.visible = (exportInfo.fileType == bmpIndex);
    
    dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb16bitGr = dlgMain.pnlFileType.pnlOptions.grpBMPOptions.add("group"); 
    dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb16bitGr .orientation = "row"; 
    dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb16bitGr. add("statictext", undefined, strLabelDepth);
    dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb16bit = dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb16bitGr.add( "radiobutton", undefined, strRadiobutton16bit);
    dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb24bit = dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb16bitGr.add( "radiobutton", undefined, strRadiobutton24bit);
    dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb32bit = dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb16bitGr.add( "radiobutton", undefined, strRadiobutton32bit);

    dlgMain.pnlFileType.pnlOptions.grpBMPOptionsIccGr = dlgMain.pnlFileType.pnlOptions.grpBMPOptions.add("group");
    dlgMain.cbIccBMP = dlgMain.pnlFileType.pnlOptions.grpBMPOptionsIccGr.add("checkbox", undefined, strCheckboxIncludeICCProfile);
    dlgMain.cbIccBMP.value = exportInfo.iccBMP;

    switch (exportInfo.bmpDepth) {
        case BMPDepthType.SIXTEEN:   dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb16bit.value = true;   break;
        case BMPDepthType.TWENTYFOUR:dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb24bit.value = true;   break;
        case BMPDepthType.THIRTYTWO: dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb32bit.value = true;   break;
        default: dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb24bit.value = true;   break;
    }


// set options panel to be hidden. 
    dlgMain.pnlOptionsShow.value = exportInfo.expOptions;
    if (exportInfo.expOptions)  dlgMain.pnlFileType.pnlOptions.show();
    if (!exportInfo.expOptions) dlgMain.pnlFileType.pnlOptions.hide();
    
 // enable checkbox functionality   
    dlgMain.pnlOptionsShow.onClick = function() 
    {
        if (dlgMain.pnlOptionsShow.value) 
            { 
            dlgMain.pnlFileType.pnlOptions.show(); 
            populateOptions(dlgMain.ddFileType.selection.index)
            }
        
        if (!dlgMain.pnlOptionsShow.value) 
            { 
            dlgMain.pnlFileType.pnlOptions.hide(); 
            } 
     } 
 
 	dlgMain.ddFileType.onChange = function() 
        {
        populateOptions(dlgMain.ddFileType.selection.index)
        }
    
    // Because I'm hiding the options now, I need to check for the correct options displayed on DD switch AND group unhide. 
    function populateOptions(selIndex)
    {
            dlgMain.pnlFileType.pnlOptions.grpPSDOptions.hide();
            dlgMain.pnlFileType.pnlOptions.grpJPEGOptions.hide();
            dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.hide();
            dlgMain.pnlFileType.pnlOptions.grpPDFOptions.hide();
            dlgMain.pnlFileType.pnlOptions.grpTargaOptions.hide();
            dlgMain.pnlFileType.pnlOptions.grpBMPOptions.hide();
            dlgMain.pnlFileType.pnlOptions.grpPNG8Options.hide();
            dlgMain.pnlFileType.pnlOptions.grpPNG24Options.hide();
		switch(selIndex) 
        {
			case bmpIndex:	
				dlgMain.pnlFileType.pnlOptions.text = strBMPOptions;
				dlgMain.pnlFileType.pnlOptions.grpBMPOptions.show();	
				break;
			case jpegIndex:	
				dlgMain.pnlFileType.pnlOptions.text = strJPEGOptions;
				dlgMain.pnlFileType.pnlOptions.grpJPEGOptions.show();	
				break;
			case tiffIndex:	
				dlgMain.pnlFileType.pnlOptions.text = strTIFFOptions;
				dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.show();	
				break;
			case pdfIndex:	
				dlgMain.pnlFileType.pnlOptions.text = strPDFOptions;
				dlgMain.pnlFileType.pnlOptions.grpPDFOptions.show();	
				break;
			case targaIndex:
				dlgMain.pnlFileType.pnlOptions.text = strTargaOptions;
				dlgMain.pnlFileType.pnlOptions.grpTargaOptions.show();	
				break;
			case png8Index:		
				dlgMain.pnlFileType.pnlOptions.text = strPNG8Options;
				dlgMain.pnlFileType.pnlOptions.grpPNG8Options.show();	
				break;
			case png24Index:		
				dlgMain.pnlFileType.pnlOptions.text = strPNG24Options;
				dlgMain.pnlFileType.pnlOptions.grpPNG24Options.show();	
				break;
			case psdIndex:	
			default:		
				dlgMain.pnlFileType.pnlOptions.text = strPSDOptions;
				dlgMain.pnlFileType.pnlOptions.grpPSDOptions.show();	
				break;
          }
     }
 
    
	// the bottom of the dialog 
	dlgMain.grpTopRight = dlgMain.grpTop.add("group");
    dlgMain.grpTopRight.alignment = "right"
	dlgMain.grpTopRight.orientation = 'row';

	dlgMain.btnCancel = dlgMain.grpTopRight.add("button", undefined, strButtonCancel, {text: 'Cancel'});
    
    dlgMain.btnCancel.onClick = function() { 
		dlgMain.close(cancelButtonID); 
	}

	dlgMain.btnRun = dlgMain.grpTopRight.add("button", undefined, strButtonRun, {text: 'OK'} );
    
    dlgMain.btnRun.onClick = function() {
		// check if the setting is properly
		var destination = dlgMain.etDestination.text;
		if (destination.length == 0) {
	        alert(strAlertSpecifyDestination);
			return;
		}
		var testFolder = new Folder(destination);
		if (!testFolder.exists) {
	        alert(strAlertDestinationNotExist);
			return;
		}
    
		dlgMain.close(runButtonID);
	}


	dlgMain.defaultElement = dlgMain.btnRun;
	dlgMain.cancelElement = dlgMain.btnCancel;

    dlgMain.onShow = function() 
    {
		dlgMain.ddFileType.onChange();
	}
	
    // give the hosting app the focus before showing the dialog
    app.bringToFront();

    dlgMain.center();
    
    var result = dlgMain.show();
    
    if (cancelButtonID == result) {
		return result;  // close to quit
	}

      
    
    // get setting from dialog
    exportInfo.destination = dlgMain.etDestination.text;
    exportInfo.fileNamePrefix = dlgMain.etFileNamePrefix.text;
    exportInfo.selectionOnly = dlgMain.cbSelection.value;
    exportInfo.includeOverlaping = dlgMain.cbOverlaping.value;
    exportInfo.expOptions = dlgMain.pnlOptionsShow.value;
    exportInfo.contentOnly = dlgMain.cbContentOnly.value;
    exportInfo.fileType = dlgMain.ddFileType.selection.index;
    exportInfo.preserveArtboard = dlgMain.preserveArtboard.value;
     
    exportInfo.iccPDF = dlgMain.cbIccPDF.value;
    exportInfo.iccPSD = dlgMain.cbIccPSD.value;
    exportInfo.iccPNG8 = dlgMain.cbIccPNG8.value;
    exportInfo.iccPNG24 = dlgMain.cbIccPNG24.value;
    exportInfo.iccTIF = dlgMain.cbIccTIF.value;
    exportInfo.iccBMP = dlgMain.cbIccBMP.value;
    exportInfo.iccTGA = dlgMain.cbIccTGA.value;
    exportInfo.iccJPG = dlgMain.cbIccJPG.value;
                                    
    exportInfo.jpegQuality = dlgMain.pnlFileType.pnlOptions.grpJPEGOptions.etQuality.text;
    exportInfo.psdMaxComp = dlgMain.pnlFileType.pnlOptions.grpPSDOptions.cbMax.value;
    exportInfo.png8Transparency = dlgMain.pnlFileType.pnlOptions.grpPNG8Options.png8Trans.value;
    exportInfo.png8Interlaced = dlgMain.pnlFileType.pnlOptions.grpPNG8Options.png8Inter.value;
    exportInfo.inclFilename = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.chincludeName.value;
    //exportInfo.png8Trim = dlgMain.pnlFileType.pnlOptions.grpPNG8Options.png8Trm.value;
    exportInfo.png24Transparency = dlgMain.pnlFileType.pnlOptions.grpPNG24Options.png24Trans.value;
    exportInfo.png24Interlaced = dlgMain.pnlFileType.pnlOptions.grpPNG24Options.png24Inter.value;
    //exportInfo.png24Trim = dlgMain.pnlFileType.pnlOptions.grpPNG24Options.png24Trm.value;
    index = dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpCompression.ddCompression.selection.index;
    if (index == compNoneIndex) {
		exportInfo.tiffCompression = TIFFEncoding.NONE;
	}
    if (index == compLZWIndex) {
		exportInfo.tiffCompression = TIFFEncoding.TIFFLZW;
	}
    if (index == compZIPIndex) {
		exportInfo.tiffCompression = TIFFEncoding.TIFFZIP;
	}
    if (index == compJPEGIndex) {
		exportInfo.tiffCompression = TIFFEncoding.JPEG;
	}
    exportInfo.tiffJpegQuality = dlgMain.pnlFileType.pnlOptions.grpTIFFOptions.grpQuality.etQuality.text;
    if (dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.rbZip.value) {
		exportInfo.pdfEncoding = PDFEncoding.PDFZIP;
	}
    if (dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpCompression.rbJpeg.value) {
		exportInfo.pdfEncoding = PDFEncoding.JPEG;
	}
// pdf export settings. 
    exportInfo.multipage = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.multipage.value;
    exportInfo.singlepage = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpPresentation.singlepage.value;

    exportInfo.pdfJpegQuality = dlgMain.pnlFileType.pnlOptions.grpPDFOptions.grpQuality.etQuality.text;
    
    if (dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb16bit.value) {
		exportInfo.targaDepth = TargaBitsPerPixels.SIXTEEN;
	}
    if (dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb24bit.value) {
		exportInfo.targaDepth = TargaBitsPerPixels.TWENTYFOUR;
	}
    if (dlgMain.pnlFileType.pnlOptions.grpTargaOptions.rb32bit.value) {
		exportInfo.targaDepth = TargaBitsPerPixels.THIRTYTWO;
	}
    if (dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb16bit.value) {
		exportInfo.bmpDepth = BMPDepthType.SIXTEEN;
	}
    if (dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb24bit.value) {
		exportInfo.bmpDepth = BMPDepthType.TWENTYFOUR;
	}
    if (dlgMain.pnlFileType.pnlOptions.grpBMPOptions.rb32bit.value) { 
		exportInfo.bmpDepth = BMPDepthType.THIRTYTWO;
	}



    return result;
}


// DEFINED IN INDIVIDUAL INSTANCES NOT IN INCLUDE FILE
//~ ///////////////////////////////////////////////////////////////////////////////
//~ // Function: initExportInfo
//~ // Usage: create our default parameters
//~ // Input: a new Object
//~ // Return: a new object with params set to default
//~ ///////////////////////////////////////////////////////////////////////////////
//~ function initExportInfo(exportInfo, isSelection) {
//~     exportInfo.destination = new String("");
//~     exportInfo.fileNamePrefix = new String("untitled_");
//~     if (isSelection) exportInfo.selectionOnly = true;
//~     if (!isSelection) exportInfo.selectionOnly = false;
//~     exportInfo.includeOverlaping = true;
//~     exportInfo.expOptions = false;
//~     exportInfo.contentOnly = false;
//~     exportInfo.fileType = psdIndex;
//~     exportInfo.icc = true;
//~     exportInfo.jpegQuality = 8;
//~     exportInfo.psdMaxComp = true;
//~     exportInfo.tiffCompression = TIFFEncoding.NONE;
//~     exportInfo.tiffJpegQuality = 8;
//~     exportInfo.pdfEncoding = PDFEncoding.JPEG;
//~     exportInfo.pdfJpegQuality = 8;
//~     exportInfo.targaDepth = TargaBitsPerPixels.TWENTYFOUR;
//~     exportInfo.bmpDepth = BMPDepthType.TWENTYFOUR;
//~     exportInfo.png24Transparency = true;
//~     exportInfo.png24Interlaced = false;
//~     exportInfo.png24Trim = true;
//~     exportInfo.png8Transparency = true;
//~     exportInfo.png8Interlaced = false;
//~     exportInfo.png8Trim = true;

//~     //init pdf settings 
//~     exportInfo.multipage = true;
//~     exportInfo.inclFilename = false; 
//~     //exportInfo.background = 0;
//~     exportInfo.pdfJpegQuality = 8;

//~     try {
//~         exportInfo.destination = Folder(app.activeDocument.fullName.parent).fsName; // destination folder
//~         var tmp = app.activeDocument.fullName.name;
//~         exportInfo.fileNamePrefix = decodeURI(tmp.substring(0, tmp.indexOf("."))); // filename body part
//~     } catch(someError) {
//~         exportInfo.destination = new String("");
//~         exportInfo.fileNamePrefix = app.activeDocument.name; // filename body part
//~     }
//~ }


///////////////////////////////////////////////////////////////////////////////
// Function: initFileNameDestination
// Usage: read the filename and path from the current document, overriding saved or recorded parameters
// Input: an initialized object
// Return: a modified object
///////////////////////////////////////////////////////////////////////////////
function initFileNameDestination(exportInfo) {
    try {
        exportInfo.destination = Folder(app.activeDocument.fullName.parent).fsName; // destination folder
        var tmp = app.activeDocument.fullName.name;
        exportInfo.fileNamePrefix = decodeURI(tmp.substring(0, tmp.indexOf("."))); // filename body part
    } catch(someError) {
        exportInfo.destination = new String("");
        exportInfo.fileNamePrefix = app.activeDocument.name; // filename body part
    }
}


///////////////////////////////////////////////////////////////////////////////
// Function: saveFileNow
// Usage: the worker routine, take our params and save the file accordingly
// Input: reference to the document, the name of the output file, 
//        export info object containing more information
// Return: <none>, a file on disk
///////////////////////////////////////////////////////////////////////////////
function saveFileNow( docRef, fileNameBody, exportInfo) {

    var isS4W = false,
        fileExtension;
    switch (exportInfo.fileType) {
        case jpegIndex:
            fileExtension = "jpg";
	        docRef.bitsPerChannel = BitsPerChannelType.EIGHT;
            var saveFile = new File(exportInfo.destination + "/" + fileNameBody + ".jpg");
            jpgSaveOptions = new JPEGSaveOptions();
            jpgSaveOptions.embedColorProfile = exportInfo.iccJPG;
            jpgSaveOptions.quality = exportInfo.jpegQuality;
            docRef.saveAs(saveFile, jpgSaveOptions, true, Extension.LOWERCASE);
            break;
        case psdIndex:
            fileExtension = "psd";
            var saveFile = new File(exportInfo.destination + "/" + fileNameBody + ".psd");
            psdSaveOptions = new PhotoshopSaveOptions();
            psdSaveOptions.embedColorProfile = exportInfo.iccPSD;
            psdSaveOptions.maximizeCompatibility = exportInfo.psdMaxComp;
            docRef.saveAs(saveFile, psdSaveOptions, true, Extension.LOWERCASE);
            break;
        case tiffIndex:
            fileExtension = "tiff";
            var saveFile = new File(exportInfo.destination + "/" + fileNameBody + ".tif");
            tiffSaveOptions = new TiffSaveOptions();
            tiffSaveOptions.embedColorProfile = exportInfo.iccTIF;
            tiffSaveOptions.imageCompression = exportInfo.tiffCompression;
            if (TIFFEncoding.JPEG == exportInfo.tiffCompression) {
				tiffSaveOptions.jpegQuality = exportInfo.tiffJpegQuality;
			}
            docRef.saveAs(saveFile, tiffSaveOptions, true, Extension.LOWERCASE);
            break;
        case pdfIndex:
        // if multipage is true, then I need to run PSD save and then make Presentation when the script is all done.  (that is in MAIN())  
        if (exportInfo.multipage) 
            {
                 fileExtension = "psd";
                var tempPSDs = (exportInfo.destination + "/TempPSDs");
                if (!Folder(tempPSDs).exists) { Folder(tempPSDs).create(); } 
                var saveFile = new File(tempPSDs + "/" + fileNameBody + ".psd");
                psdSaveOptions = new PhotoshopSaveOptions();
                psdSaveOptions.embedColorProfile = exportInfo.iccPDF;
                psdSaveOptions.maximizeCompatibility = exportInfo.psdMaxComp;
                docRef.saveAs(saveFile, psdSaveOptions, true, Extension.LOWERCASE);
                // when script is done I make presentation out of temp files and clean up directory.  
            }
        // if multipage is false then I know I am exporting seperate files. 
        if (exportInfo.singlepage) 
        {
                fileExtension = "pdf";
                if (docRef.bitsPerChannel == BitsPerChannelType.THIRTYTWO)
                    docRef.bitsPerChannel = BitsPerChannelType.SIXTEEN;
                var saveFile = new File(exportInfo.destination + "/" + fileNameBody + ".pdf");
                pdfSaveOptions = new PDFSaveOptions();
                pdfSaveOptions.embedColorProfile = exportInfo.iccPDF;
                pdfSaveOptions.encoding = exportInfo.pdfEncoding;
                if (PDFEncoding.JPEG == exportInfo.pdfEncoding) {
                    pdfSaveOptions.jpegQuality = exportInfo.pdfJpegQuality;
                }
                docRef.saveAs(saveFile, pdfSaveOptions, true, Extension.LOWERCASE);
           } 
            break;
        case targaIndex:
             fileExtension = "tga";
	    	docRef.bitsPerChannel = BitsPerChannelType.EIGHT;
            var saveFile = new File(exportInfo.destination + "/" + fileNameBody + ".tga");
            targaSaveOptions = new TargaSaveOptions();
            targaSaveOptions.resolution = exportInfo.targaDepth;
            
            docRef.saveAs(saveFile, targaSaveOptions, true, Extension.LOWERCASE);
            break;
        case bmpIndex:
            fileExtension = "bmp";
	    	docRef.bitsPerChannel = BitsPerChannelType.EIGHT;
            var saveFile = new File(exportInfo.destination + "/" + fileNameBody + ".bmp");
            bmpSaveOptions = new BMPSaveOptions();
            bmpSaveOptions.depth = exportInfo.bmpDepth;
            docRef.saveAs(saveFile, bmpSaveOptions, true, Extension.LOWERCASE);
            break;
        case png8Index:
              fileExtension "png8";
              isS4W = true;
			var id5 = charIDToTypeID( "Expr" );
			var desc3 = new ActionDescriptor();
			var id6 = charIDToTypeID( "Usng" );
			var desc4 = new ActionDescriptor();
			var id7 = charIDToTypeID( "Op  " );
			var id8 = charIDToTypeID( "SWOp" );
			var id9 = charIDToTypeID( "OpSa" );
			desc4.putEnumerated( id7, id8, id9 );
			var id10 = charIDToTypeID( "Fmt " );
			var id11 = charIDToTypeID( "IRFm" );
			var id12 = charIDToTypeID( "PNG8" );
			desc4.putEnumerated( id10, id11, id12 );
			var id13 = charIDToTypeID( "Intr" ); //Interlaced
			desc4.putBoolean( id13, exportInfo.png8Interlaced );
			var id14 = charIDToTypeID( "RedA" );
			var id15 = charIDToTypeID( "IRRd" );
			var id16 = charIDToTypeID( "Prcp" ); //Algorithm
			desc4.putEnumerated( id14, id15, id16 );
			var id17 = charIDToTypeID( "RChT" );
			desc4.putBoolean( id17, false );
			var id18 = charIDToTypeID( "RChV" );
			desc4.putBoolean( id18, false );
			var id19 = charIDToTypeID( "AuRd" );
			desc4.putBoolean( id19, false );
			var id20 = charIDToTypeID( "NCol" ); //NO. Of Colors
			desc4.putInteger( id20, 256 );
			var id21 = charIDToTypeID( "Dthr" ); //Dither
			var id22 = charIDToTypeID( "IRDt" );
			var id23 = charIDToTypeID( "Dfsn" ); //Dither type
			desc4.putEnumerated( id21, id22, id23 );
			var id24 = charIDToTypeID( "DthA" );
			desc4.putInteger( id24, 100 );
			var id25 = charIDToTypeID( "DChS" );
			desc4.putInteger( id25, 0 );
			var id26 = charIDToTypeID( "DCUI" );
			desc4.putInteger( id26, 0 );
			var id27 = charIDToTypeID( "DChT" );
			desc4.putBoolean( id27, false );
			var id28 = charIDToTypeID( "DChV" );
			desc4.putBoolean( id28, false );
			var id29 = charIDToTypeID( "WebS" );
			desc4.putInteger( id29, 0 );
			var id30 = charIDToTypeID( "TDth" ); //transparency dither
			var id31 = charIDToTypeID( "IRDt" );
			var id32 = charIDToTypeID( "None" );
			desc4.putEnumerated( id30, id31, id32 );
			var id33 = charIDToTypeID( "TDtA" );
			desc4.putInteger( id33, 100 );
			var id34 = charIDToTypeID( "Trns" ); //Transparency
			desc4.putBoolean( id34, exportInfo.png8Transparency );
			var id35 = charIDToTypeID( "Mtt " );
			desc4.putBoolean( id35, true );		 //matte
			var id36 = charIDToTypeID( "MttR" ); //matte color
			desc4.putInteger( id36, 255 );
			var id37 = charIDToTypeID( "MttG" );
			desc4.putInteger( id37, 255 );
			var id38 = charIDToTypeID( "MttB" );
			desc4.putInteger( id38, 255 );
			var id39 = charIDToTypeID( "SHTM" );
			desc4.putBoolean( id39, false );
			var id40 = charIDToTypeID( "SImg" );
			desc4.putBoolean( id40, true );
			var id41 = charIDToTypeID( "SSSO" );
			desc4.putBoolean( id41, false );
			var id42 = charIDToTypeID( "SSLt" );
			var list1 = new ActionList();
			desc4.putList( id42, list1 );
			var id43 = charIDToTypeID( "DIDr" );
			desc4.putBoolean( id43, false );
			var id44 = charIDToTypeID( "In  " );
			desc4.putPath( id44, new File( exportInfo.destination + "/" + fileNameBody + ".png") );
			var id45 = stringIDToTypeID( "SaveForWeb" );
			desc3.putObject( id6, id45, desc4 );
			executeAction( id5, desc3, DialogModes.NO );
            break;
        case png24Index:
            fileExtension "png24";
            if(exportInfo.png24Transparency) {
                fileExtension = "png32"
            }
             isS4W = true;
			var id6 = charIDToTypeID( "Expr" );
			var desc3 = new ActionDescriptor();
			var id7 = charIDToTypeID( "Usng" );
			var desc4 = new ActionDescriptor();
			var id8 = charIDToTypeID( "Op  " );
			var id9 = charIDToTypeID( "SWOp" );
			var id10 = charIDToTypeID( "OpSa" );
	        desc4.putEnumerated( id8, id9, id10 );
			var id11 = charIDToTypeID( "Fmt " );
			var id12 = charIDToTypeID( "IRFm" );
			var id13 = charIDToTypeID( "PN24" );
			desc4.putEnumerated( id11, id12, id13 );
			var id14 = charIDToTypeID( "Intr" );
			desc4.putBoolean( id14, exportInfo.png24Interlaced );
			var id15 = charIDToTypeID( "Trns" );
			desc4.putBoolean( id15, exportInfo.png24Transparency );
			var id16 = charIDToTypeID( "Mtt " );
			desc4.putBoolean( id16, true );
			var id17 = charIDToTypeID( "MttR" );
			desc4.putInteger( id17, 255 );
			var id18 = charIDToTypeID( "MttG" );
			desc4.putInteger( id18, 255 );
			var id19 = charIDToTypeID( "MttB" );
			desc4.putInteger( id19, 255 );
			var id20 = charIDToTypeID( "SHTM" );
			desc4.putBoolean( id20, false );
			var id21 = charIDToTypeID( "SImg" );
			desc4.putBoolean( id21, true );
			var id22 = charIDToTypeID( "SSSO" );
			desc4.putBoolean( id22, false );
			var id23 = charIDToTypeID( "SSLt" );
			var list1 = new ActionList();
			desc4.putList( id23, list1 );
			var id24 = charIDToTypeID( "DIDr" );
			desc4.putBoolean( id24, false );
			var id25 = charIDToTypeID( "In  " );
			desc4.putPath( id25, new File( exportInfo.destination + "/" + fileNameBody + ".png") );
            var id26 = stringIDToTypeID( "SaveForWeb" );
			desc3.putObject( id7, id26, desc4 );
			executeAction( id6, desc3, DialogModes.NO );
            break;
        default:
            if ( DialogModes.NO != app.playbackDisplayDialogs ) {
                alert(strUnexpectedError);
            }
            break;
    }
    logToHeadLights(strTitle + " file type exported: " + fileExtension);
}


///////////////////////////////////////////////////////////////////////////////
// Function: zeroSuppress
// Usage: return a string padded to digit(s)
// Input: num to convert, digit count needed
// Return: string padded to digit length
///////////////////////////////////////////////////////////////////////////////
function zeroSuppress (num, digit) {
    var tmp = num.toString();
    while (tmp.length < digit) {
		tmp = "0" + tmp;
	}
    return tmp;
}



///////////////////////////////////////////////////////////////////////////////
// Function: removeAllEmptyLayerSets
// Usage: find all empty layer sets and remove them, recursively
// Input: document or layer set
// Return: empty layer sets are now gone
///////////////////////////////////////////////////////////////////////////////
function removeAllEmptyLayerSets(obj) {
    var foundEmpty = true;
    for( var i = obj.layerSets.length-1; 0 <= i; i--) {
        if( removeAllEmptyLayerSets(obj.layerSets[i])) {
            obj.layerSets[i].remove();
        } else {
            foundEmpty = false;
        }
    }
    if (obj.artLayers.length > 0) {
		foundEmpty = false;
	}
    return foundEmpty;
}


///////////////////////////////////////////////////////////////////////////////
// Function: zeroSuppress
// Usage: return a string padded to digit(s)
// Input: num to convert, digit count needed
// Return: string padded to digit length
///////////////////////////////////////////////////////////////////////////////
function zeroSuppress (num, digit) {
    var tmp = num.toString();
    while (tmp.length < digit) {
		tmp = "0" + tmp;
	}
    return tmp;
}



///////////////////////////////////////////////////////////////////////////////
// Function: objectToDescriptor
// Usage: create an ActionDescriptor from a JavaScript Object
// Input: JavaScript Object (o)
//        object unique string (s)
//        Pre process converter (f)
// Return: ActionDescriptor
// NOTE: Only boolean, string, number and UnitValue are supported, use a pre processor
//       to convert (f) other types to one of these forms.
// REUSE: This routine is used in other scripts. Please update those if you 
//        modify. I am not using include or eval statements as I want these 
//        scripts self contained.
///////////////////////////////////////////////////////////////////////////////
function objectToDescriptor (o, s, f) {
	if (undefined != f) {
		o = f(o);
	}
	var d = new ActionDescriptor;
	var l = o.reflect.properties.length;
	d.putString( app.charIDToTypeID( 'Msge' ), s );
	for (var i = 0; i < l; i++ ) {
		var k = o.reflect.properties[i].toString();
		if (k == "__proto__" || k == "__count__" || k == "__class__" || k == "reflect")
			continue;
		var v = o[ k ];
		k = app.stringIDToTypeID(k);
		switch ( typeof(v) ) {
			case "boolean":
				d.putBoolean(k, v);
				break;
			case "string":
				d.putString(k, v);
				break;
			case "number":
				d.putDouble(k, v);
				break;
			default:
			{
				if ( v instanceof UnitValue ) {
					var uc = new Object;
					uc["px"] = charIDToTypeID("#Rlt"); // unitDistance
					uc["%"] = charIDToTypeID("#Prc"); // unitPercent
					d.putUnitDouble(k, uc[v.type], v.value);
				} else {
					throw( new Error("Unsupported type in objectToDescriptor " + typeof(v) ) );
				}
			}
		}
	}
    return d;
}


///////////////////////////////////////////////////////////////////////////////
// Function: descriptorToObject
// Usage: update a JavaScript Object from an ActionDescriptor
// Input: JavaScript Object (o), current object to update (output)
//        Photoshop ActionDescriptor (d), descriptor to pull new params for object from
//        object unique string (s)
//        JavaScript Function (f), post process converter utility to convert
// Return: Nothing, update is applied to passed in JavaScript Object (o)
// NOTE: Only boolean, string, number and UnitValue are supported, use a post processor
//       to convert (f) other types to one of these forms.
// REUSE: This routine is used in other scripts. Please update those if you 
//        modify. I am not using include or eval statements as I want these 
//        scripts self contained.
///////////////////////////////////////////////////////////////////////////////
function descriptorToObject (o, d, s, f) {
	var l = d.count;
	if (l) {
	    var keyMessage = app.charIDToTypeID( 'Msge' );
        if ( d.hasKey(keyMessage) && ( s != d.getString(keyMessage) )) return;
	}
	for (var i = 0; i < l; i++ ) {
		var k = d.getKey(i); // i + 1 ?
		var t = d.getType(k);
		strk = app.typeIDToStringID(k);
		switch (t) {
			case DescValueType.BOOLEANTYPE:
				o[strk] = d.getBoolean(k);
				break;
			case DescValueType.STRINGTYPE:
				o[strk] = d.getString(k);
				break;
			case DescValueType.DOUBLETYPE:
				o[strk] = d.getDouble(k);
				break;
			case DescValueType.UNITDOUBLE:
				{
				var uc = new Object;
				uc[charIDToTypeID("#Rlt")] = "px"; // unitDistance
				uc[charIDToTypeID("#Prc")] = "%"; // unitPercent
				uc[charIDToTypeID("#Pxl")] = "px"; // unitPixels
				var ut = d.getUnitDoubleType(k);
				var uv = d.getUnitDoubleValue(k);
				o[strk] = new UnitValue( uv, uc[ut] );
				}
				break;
			case DescValueType.INTEGERTYPE:
			case DescValueType.ALIASTYPE:
			case DescValueType.CLASSTYPE:
			case DescValueType.ENUMERATEDTYPE:
			case DescValueType.LISTTYPE:
			case DescValueType.OBJECTTYPE:
			case DescValueType.RAWTYPE:
			case DescValueType.REFERENCETYPE:
			default:
				throw( new Error("Unsupported type in descriptorToObject " + t ) );
		}
	}
	if (undefined != f) {
		o = f(o);
	}
}


///////////////////////////////////////////////////////////////////////////
// Function: StrToIntWithDefault
// Usage: convert a string to a number, first stripping all characters
// Input: string and a default number
// Return: a number
///////////////////////////////////////////////////////////////////////////
function StrToIntWithDefault( s, n ) {
    var onlyNumbers = /[^0-9]/g;
    var t = s.replace( onlyNumbers, "" );
	t = parseInt( t );
	if ( ! isNaN( t ) ) {
        n = t;
    }
    return n;
}


///////////////////////////////////////////////////////////////////////////////
// Function: logToHeadLights
// Usage:   Logs to headlight usage data based on "export". 
// Input::   (active document.) s
// Return: array of indexes ID's of selected layers. 
///////////////////////////////////////////////////////////////////////////////
function logToHeadLights(eventRecord) 
{
    var headlightsActionID = stringIDToTypeID("headlightsLog");
    var desc = new ActionDescriptor();
    desc.putString(stringIDToTypeID("subcategory"), "Export");
    desc.putString(stringIDToTypeID("eventRecord"), eventRecord);
    executeAction(headlightsActionID, desc, DialogModes.NO);
}

///////////////////////////////////////////////////////////////////////////////
// Function: preProcessExportInfo
// Usage: convert Photoshop enums to strings for storage
// Input: JavaScript Object of my params for this script
// Return: JavaScript Object with objects converted for storage
///////////////////////////////////////////////////////////////////////////////
function preProcessExportInfo(o) {
	o.tiffCompression = o.tiffCompression.toString();
	o.pdfEncoding = o.pdfEncoding.toString();
	o.targaDepth = o.targaDepth.toString();
	o.bmpDepth = o.bmpDepth.toString();
	return o;
}

///////////////////////////////////////////////////////////////////////////////
// Function: postProcessExportInfo
// Usage: convert strings from storage to Photoshop enums
// Input: JavaScript Object of my params in string form
// Return: JavaScript Object with objects in enum form
///////////////////////////////////////////////////////////////////////////////
function postProcessExportInfo(o) {
	o.tiffCompression = eval(o.tiffCompression);
	o.pdfEncoding = eval(o.pdfEncoding);
	o.targaDepth = eval(o.targaDepth);
	o.bmpDepth = eval(o.bmpDepth);
	return o;
}


// -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//      start  unArtboard functions. 

///////////////////////////////////////////////////////////////////////////////
// Function: unArtBoard
// Usage:  master function that will ungroup all artboards in document. 
// Input:  an array of Artboard AM iD values. 
// Return:  a document where all artboards have been converted to masked layersets. 
///////////////////////////////////////////////////////////////////////////////

function unArtBoard(abAr, srcDoc)
{
    for (u=0;u<abAr.length;u++) 
    {
        selectLayerFromAMid(abAr[u].AMid, "'addToSelection");
        if (!ungroupArtboard(abAr[u].AMid, abAr[u].name)) { return false; } ;
        var newID = layerSetFromSelected(abAr[u].name) ;
        abAr[u].groupAMid = newID;
        
    // create selection mask for group from  AB bounds 
        var lt = abAr[u].left
        var tp = abAr[u].top
        var rt = abAr[u].right
        var bt = abAr[u].bottom
        srcDoc.selection.select ([[ lt, tp],[ rt, tp ],[ rt, bt],[lt , bt]], SelectionType.REPLACE,0,false);
        makeMaskFromSelection();   
    } 
return abAr
}    

 

///////////////////////////////////////////////////////////////////////////////
// Function: ungroupArtboard
// Usage:  will ungroup the artboard document . 
// Input:  the AM id  of an artboard document, name of Artboard 
// Return:  an ungrouped artboard. 
///////////////////////////////////////////////////////////////////////////////
function ungroupArtboard(AMid, ArName)
{
    try {
        ref = new ActionReference(); 
        ref.putIdentifier( charIDToTypeID( 'Lyr ' ), parseInt(AMid) );
        var desc = executeActionGet(ref);
        ref.putEnumerated( stringIDToTypeID( "layer" ), stringIDToTypeID( "ordinal" ), stringIDToTypeID( "targetEnum" ) );
        desc.putReference( stringIDToTypeID( "null" ), ref );
        executeAction( stringIDToTypeID( "ungroupLayersEvent" ), desc, DialogModes.NO );
        // when process is done, need to get the AMid of the active layer because it no longer is the same as the ABamID I started with. 
        //alert("original abID =" +  AMid + "   new group ID = " +  getLayerID()); 
        } 
    catch(e) 
        { 
        return false
        };
        
        return getLayerID();
}



///////////////////////////////////////////////////////////////////////////////
// Function: selectLayerFromAMid
// Usage:   Select a layer by its AMid value. 
// Input:  AM id value and type of selection,  either "addToSelectionContinuous"   or "addToSelection"
// Return: a selected layer. 
///////////////////////////////////////////////////////////////////////////////

function selectLayerFromAMid(AMid,selType)
{
        var desc01 = new ActionDescriptor();
        var ref01 = new ActionReference(); ref01.putIdentifier(charIDToTypeID('Lyr '), parseInt(AMid) );
        desc01.putReference(charIDToTypeID('null'), ref01);
        desc01.putEnumerated(stringIDToTypeID('selectionModifier'), stringIDToTypeID('selectionModifierType'), stringIDToTypeID(selType));
        desc01.putBoolean(charIDToTypeID('MkVs'), false);
        executeAction(charIDToTypeID('slct'), desc01, DialogModes.NO);
}


///////////////////////////////////////////////////////////////////////////////
// Function: layerSetFromSelected
// Usage:   the Group from Selected menu command.  Create a layerSet from all selected layers. 
// Input:  the name that you would like to give the new layerset 
// Return: a new layerset.
///////////////////////////////////////////////////////////////////////////////


function layerSetFromSelected(laySetName) 
{
        var idmake = stringIDToTypeID( "make" );
        var desc229 = new ActionDescriptor();
        var idnull = stringIDToTypeID( "null" );
        var ref170 = new ActionReference();
        var idlayerSection = stringIDToTypeID( "layerSection" );
        ref170.putClass( idlayerSection );
        desc229.putReference( idnull, ref170 );
        var idfrom = stringIDToTypeID( "from" );
        var ref171 = new ActionReference();
        var idlayer = stringIDToTypeID( "layer" );
        var idordinal = stringIDToTypeID( "ordinal" );
        var idtargetEnum = stringIDToTypeID( "targetEnum" );
        ref171.putEnumerated( idlayer, idordinal, idtargetEnum );
        desc229.putReference( idfrom, ref171 );
        var idusing = stringIDToTypeID( "using" );
        var desc230 = new ActionDescriptor();
        var idname = stringIDToTypeID( "name" );
        desc230.putString( idname,laySetName);
        var idlayerSection = stringIDToTypeID( "layerSection" );
        desc229.putObject( idusing, idlayerSection, desc230 );
        var idlayerSectionStart = stringIDToTypeID( "layerSectionStart" );
        desc229.putInteger( idlayerSectionStart, 56 );
        var idlayerSectionEnd = stringIDToTypeID( "layerSectionEnd" );
        desc229.putInteger( idlayerSectionEnd, 57 );
        var idname = stringIDToTypeID( "name" );
        desc229.putString( idname, laySetName);
        executeAction( idmake, desc229, DialogModes.NO );
        
        // when process is done, need to get the AMid of the active layer because it no longer is the same as the ABamID I started with. 
        //alert("original abID =" +  AMid + "   new group ID = " +  getLayerID()); 
        return getLayerID();
        
}

///////////////////////////////////////////////////////////////////////////////
// Function: makeMaskFromSelection
// Usage:  converts active selection to active layer's mask. 
// Input:   none.
// Return: a mask  attached to the layer.
///////////////////////////////////////////////////////////////////////////////
function makeMaskFromSelection()
{
        var idmake = stringIDToTypeID( "make" );
        var desc263 = new ActionDescriptor();
        var idnew = stringIDToTypeID( "new" );
        var idchannel = stringIDToTypeID( "channel" );
        desc263.putClass( idnew, idchannel );
        var idat = stringIDToTypeID( "at" );
        var ref197 = new ActionReference();
        var idchannel = stringIDToTypeID( "channel" );
        var idchannel = stringIDToTypeID( "channel" );
        var idmask = stringIDToTypeID( "mask" );
        ref197.putEnumerated( idchannel, idchannel, idmask );
        desc263.putReference( idat, ref197 );
        var idusing = stringIDToTypeID( "using" );
        var iduserMaskEnabled = stringIDToTypeID( "userMaskEnabled" );
        var idrevealSelection = stringIDToTypeID( "revealSelection" );
        desc263.putEnumerated( idusing, iduserMaskEnabled, idrevealSelection );
        executeAction( idmake, desc263, DialogModes.NO );
}
   
///////////////////////////////////////////////////////////////////////////////
// Function: cropFromMask
// Usage:  takes mask from named layerset and crops entire document based on the bounds of the mask. 
// Input:   LayerSet name  that contains mask for croping. 
// Return: copped file.
///////////////////////////////////////////////////////////////////////////////


function cropFromMask()
 {
var idset = stringIDToTypeID( "set" );
    var desc78 = new ActionDescriptor();
    var idnull = stringIDToTypeID( "null" );
        var ref40 = new ActionReference();
        var idchannel = stringIDToTypeID( "channel" );
        var idselection = stringIDToTypeID( "selection" );
        ref40.putProperty( idchannel, idselection );
    desc78.putReference( idnull, ref40 );
    var idto = stringIDToTypeID( "to" );
        var ref41 = new ActionReference();
        var idchannel = stringIDToTypeID( "channel" );
        var idordinal = stringIDToTypeID( "ordinal" );
        var idtargetEnum = stringIDToTypeID( "targetEnum" );
        ref41.putEnumerated( idchannel, idordinal, idtargetEnum );
    desc78.putReference( idto, ref41 );
executeAction( idset, desc78, DialogModes.NO );

    // =======================================================
    var idcrop = stringIDToTypeID( "crop" );
        var desc79 = new ActionDescriptor();
        var iddelete = stringIDToTypeID( "delete" );
        desc79.putBoolean( iddelete, true );
    executeAction( idcrop, desc79, DialogModes.NO );
} 

 // end  FUNCTIONS TO UNARTBOARD.   -----------------------------------------------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////
// Function: getABLayerInfo
// Usage:  use ActionManager to check each layer in document for artboard and extract location and AMID
// Input: nothing. 
// Return: array of artboard object data extracted.
///////////////////////////////////////////////////////////////////////////////
function getABLayerInfo(srcDoc)
{
    var abArr = [];
    
		var ref = new ActionReference(); 
		ref.putEnumerated( charIDToTypeID('Dcmn'), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') ); 
		var count = executeActionGet(ref).getInteger(charIDToTypeID('NmbL')) +1;   //  number of total layers in the document including start AND stop of groups.  So layersets get counted twice. 
		var infoList=[];
		try{ srcDoc.backgroundLayer;  var i = 0; }catch(e){ var i = 1; }; 
	
	for(i;i<count;i++)
		{ 	 
        ref = new ActionReference(); 
        ref.putIndex( charIDToTypeID( 'Lyr ' ), i );
        var desc = executeActionGet(ref);
		// this gets the layer name 
         var isArtboard =desc.getBoolean(stringIDToTypeID('artboardEnabled'));
         if (isArtboard)
               {
                var artBoardLay = {};	
                var ab_actDesc = desc.getObjectValue(stringIDToTypeID('artboard'));
                var abrect_desc = ab_actDesc.getObjectValue(stringIDToTypeID('artboardRect'));
                //~ 	// get bounds of artboard. 
                atop = parseInt(abrect_desc.getUnitDoubleValue(charIDToTypeID('Top ')))
                aleft = parseInt(abrect_desc.getUnitDoubleValue(charIDToTypeID('Left')));
                abottom = parseInt(abrect_desc.getUnitDoubleValue(charIDToTypeID('Btom')));
                aright = parseInt(abrect_desc.getUnitDoubleValue(charIDToTypeID('Rght')));
                
                 artBoardLay.result = isArtboard
                 artBoardLay.name = desc.getString(charIDToTypeID( 'Nm  ' ));
                 artBoardLay.top = atop;
                 artBoardLay.left = aleft;
                 artBoardLay.bottom = abottom;
                 artBoardLay.right = aright;
                 artBoardLay.bounds = [atop,aleft,abottom,aright];
                 artBoardLay.AMid= desc.getInteger(stringIDToTypeID( 'layerID' ));
                 artBoardLay.index = desc.getInteger(charIDToTypeID( 'ItmI' ));
                //alert([name, isLayerSet, atop,aleft,abottom,aright, name, id, index, visible] )
               abArr.push(artBoardLay); 
               
           }
       }
    return abArr;
};

///////////////////////////////////////////////////////////////////////////////
// Function: getEachABdata
// Usage:   extract weather layer is an artboard layer or not.  but either AMid or AMindx 
// Input: num - either AMid or AMindx  Type "AMid" or "AMindx")  
// Return: artboard AMid
///////////////////////////////////////////////////////////////////////////////
function getEachABdata(num,intype)
{
    var abObj = {}; //top: 2040, left: 1174, bottom: 3191, right: 3219, name:"AB1test", ID:4 
     abObj.result = false;  
 
    ref = new ActionReference(); 
	if (intype == "AMid")  {  ref.putIdentifier( charIDToTypeID( 'Lyr ' ), parseInt(num) ); }
	if (intype == "AMindx")  { ref.putIndex( charIDToTypeID( 'Lyr ' ), parseInt(num) );  }
	
    var desc = executeActionGet(ref);
	
	var ab_actDesc = desc.getObjectValue(stringIDToTypeID('artboard'));
	var abrect_desc = ab_actDesc.getObjectValue(stringIDToTypeID('artboardRect'));
	// get bounds of artboard. 
		abObj.top = parseInt(abrect_desc.getUnitDoubleValue(charIDToTypeID('Top ')))
		abObj.left = parseInt(abrect_desc.getUnitDoubleValue(charIDToTypeID('Left')));
		abObj.bottom = parseInt(abrect_desc.getUnitDoubleValue(charIDToTypeID('Btom')));
		abObj.right = parseInt(abrect_desc.getUnitDoubleValue(charIDToTypeID('Rght')));
		
		// add the 4 values together, and if they are 0  then I know its not an actual artboard. 
		var checVal = (abObj.top+abObj.left+abObj.bottom+abObj.right);
		if (checVal === 0)  return abObj;
		
		abObj.name = desc.getString(charIDToTypeID( 'Nm  ' ));
		abObj.AMid = desc.getInteger(stringIDToTypeID( 'layerID' ));
		abObj.result = true; 
        
    return abObj 
 }


///////////////////////////////////////////////////////////////////////////////
// Function: getLayerID
// Usage:  Used to get ActionManager layer ID value
// Input: active layer in active document
// Return: the Am ID ofthe active layer in the active document.
///////////////////////////////////////////////////////////////////////////////
function getLayerID()
{
    var ref = new ActionReference();
    ref.putEnumerated( charIDToTypeID('Lyr '),charIDToTypeID('Ordn'),charIDToTypeID('Trgt') );
    amID = executeActionGet(ref).getInteger(stringIDToTypeID( "layerID" ));
    return amID;
}



///////////////////////////////////////////////////////////////////////////////
// Function: getSelectedLayersAMIdx
// Usage:   extract a list of index values of all the selected layers. 
// Input::   (active document.) s
// Return: array of indexes ID's of selected layers. 
///////////////////////////////////////////////////////////////////////////////
function getSelectedLayersAMIdx(srcDoc)
{
	  var selectedLayers = new Array;
	  var ref = new ActionReference();
	  // get a number list of selected artLayers in the document
	  ref.putEnumerated( charIDToTypeID("Dcmn"), charIDToTypeID("Ordn"), charIDToTypeID("Trgt") );
	  // what do I want to do this this list?  Define an description of an action.
	  var desc = executeActionGet(ref);
	  // if the selected object has the "Target Layers" key  (only works cs4 + ) 
	  if( desc.hasKey( stringIDToTypeID( 'targetLayers' ) ) )
	  {
		 desc = desc.getList( stringIDToTypeID( 'targetLayers' ));
		  var c = desc.count 
		  var selectedLayers = [];  // for each 
		  for(var i=0;i<c;i++){
			try{ 
			   srcDoc.backgroundLayer;  // try to select a background layer, if I can then adjust the index counting.  (Background layers change index counitng of all layers by 1) 
			   selectedLayers.push(  desc.getReference( i ).getIndex() );
			}catch(e){
			   selectedLayers.push(  desc.getReference( i ).getIndex()+1 );
			}
		  }
	   }
	  return selectedLayers;
}


///////////////////////////////////////////////////////////////////////////////
// Function: artboardFromLayers
// Usage: create an artboard out of selected layers
// Input: nameString you would like to name new artboard
// Return: none  
///////////////////////////////////////////////////////////////////////////////
function artboardFromLayers(abName)
{
    var idmake = stringIDToTypeID( "make" );
    var desc66 = new ActionDescriptor();
    var idnull = stringIDToTypeID( "null" );
        var ref46 = new ActionReference();
        var idartboardSection = stringIDToTypeID( "artboardSection" );
        ref46.putClass( idartboardSection );
    desc66.putReference( idnull, ref46 );
    var idfrom = stringIDToTypeID( "from" );
        var ref47 = new ActionReference();
        var idlayer = stringIDToTypeID( "layer" );
        var idordinal = stringIDToTypeID( "ordinal" );
        var idtargetEnum = stringIDToTypeID( "targetEnum" );
        ref47.putEnumerated( idlayer, idordinal, idtargetEnum );
    desc66.putReference( idfrom, ref47 );
    var idusing = stringIDToTypeID( "using" );
        var desc67 = new ActionDescriptor();
        var idname = stringIDToTypeID( "name" );
        desc67.putString( idname, abName);
    var idartboardSection = stringIDToTypeID( "artboardSection" );
    desc66.putObject( idusing, idartboardSection, desc67 );
    var idlayerSectionStart = stringIDToTypeID( "layerSectionStart" );
    desc66.putInteger( idlayerSectionStart, 74 );
    var idlayerSectionEnd = stringIDToTypeID( "layerSectionEnd" );
    desc66.putInteger( idlayerSectionEnd, 75 );
    var idname = stringIDToTypeID( "name" );
    desc66.putString( idname, abName );
executeAction( idmake, desc66, DialogModes.NO );
    
} 


///////////////////////////////////////////////////////////////////////////////
// Function: createSolidColorLayer
// Usage: create an new solid color layer.  (underneath the current selected layer) 
// Input: RGB values of new color for solid layer. 
// Return: none  
///////////////////////////////////////////////////////////////////////////////
function createSolidColorLayer(Red, Green, Blue) 
{
var idmake = stringIDToTypeID( "make" );
    var desc44 = new ActionDescriptor();
    var idnull = stringIDToTypeID( "null" );
        var ref28 = new ActionReference();
        var idcontentLayer = stringIDToTypeID( "contentLayer" );
        ref28.putClass( idcontentLayer );
    desc44.putReference( idnull, ref28 );
    var idusing = stringIDToTypeID( "using" );
        var desc45 = new ActionDescriptor();
        var idtype = stringIDToTypeID( "type" );
            var desc46 = new ActionDescriptor();
            var idcolor = stringIDToTypeID( "color" );
                var desc47 = new ActionDescriptor();
                var idred = stringIDToTypeID( "red" );
                desc47.putDouble( idred, Red);
                var idgrain = stringIDToTypeID( "grain" );
                desc47.putDouble( idgrain, Green);
                var idblue = stringIDToTypeID( "blue" );
                desc47.putDouble( idblue, Blue );
            var idRGBColor = stringIDToTypeID( "RGBColor" );
            desc46.putObject( idcolor, idRGBColor, desc47 );
        var idsolidColorLayer = stringIDToTypeID( "solidColorLayer" );
        desc45.putObject( idtype, idsolidColorLayer, desc46 );
    var idcontentLayer = stringIDToTypeID( "contentLayer" );
    desc44.putObject( idusing, idcontentLayer, desc45 );
executeAction( idmake, desc44, DialogModes.NO );
} 

///////////////////////////////////////////////////////////////////////////////
// Function: setEnabled
// Usage: To disable or enable scriptable optoins for artboards 
// Input: a parameter to toggle: "autoExpandEnabled", "autoNestEnabled", "autoPositionEnabled"  and toggle boolean.
// Return: none. 
///////////////////////////////////////////////////////////////////////////////
function setEnabled(feature, bool) 
{
    // input "autoExpandEnabled", "autoNestEnabled", "autoPositionEnabled"
    var ref = new ActionReference();
    var desc = new ActionDescriptor();
    ref.putEnumerated( stringIDToTypeID( "layer" ), charIDToTypeID("Ordn"), charIDToTypeID("Trgt") ); 
    desc.putReference( stringIDToTypeID( "null" ), ref );
    desc.putBoolean( stringIDToTypeID( feature ), bool );
    executeAction( stringIDToTypeID( "editArtboardEvent" ) , desc, DialogModes.NO );
}

///////////////////////////////////////////////////////////////////////////////
// Function: artboardDuplToNewDoc
// Usage: selected artboard gets duplicated to new document 
// Input: selected artboard. 
// Return:  none
///////////////////////////////////////////////////////////////////////////////
function artboardDuplToNewDoc (docName) 
{    
        var idmake = stringIDToTypeID( "make" );
        var desc782 = new ActionDescriptor();
        var idnull = stringIDToTypeID( "null" );
        var ref410 = new ActionReference();
        var iddocument = stringIDToTypeID( "document" );
        ref410.putClass( iddocument );
        desc782.putReference( idnull, ref410 );
        var idname = stringIDToTypeID( "name" );
        desc782.putString( idname, docName);
        var idusing = stringIDToTypeID( "using" );
        var ref411 = new ActionReference();
        var idlayer = stringIDToTypeID( "layer" );
        var idordinal = stringIDToTypeID( "ordinal" );
        var idtargetEnum = stringIDToTypeID( "targetEnum" );
        ref411.putEnumerated( idlayer, idordinal, idtargetEnum );
        desc782.putReference( idusing, ref411 );
        var idversion = stringIDToTypeID( "version" );
        desc782.putInteger( idversion, 5 );
        executeAction( idmake, desc782, DialogModes.NO );
}


//  START  functions to remove empty layers. 
///////////////////////////////////////////////////////////////////////////////
// Function: removeEmpty Layers
// Usage: after a cropy, I get new data array of Bounds and ID's for artboards and  if bounds of the layer is 0, then I know its empty, so delete.by ID  (does not work on vector layers) 
// Input: inDocument
// Return: none. 
///////////////////////////////////////////////////////////////////////////////
function removeEmptyLayers(srcDoc) 
{
    var getInfo = getLayerInfo(srcDoc);
    for (i=0;i<getInfo.length;i++)
    {
        var addBounds = (getInfo[i].bounds[0] + getInfo[i].bounds[1] + getInfo[i].bounds[2] + getInfo[i].bounds[3]) 
        if (addBounds === 0 ) 
        {
            deleteByID(getInfo[i].id)
        } 
    }
}
function getLayerInfo(srcDoc)
{
		var ref = new ActionReference(); 
		ref.putEnumerated( charIDToTypeID('Dcmn'), charIDToTypeID('Ordn'), charIDToTypeID('Trgt') ); 
		var count = executeActionGet(ref).getInteger(charIDToTypeID('NmbL')) +1;   //  number of total layers in the document including start AND stop of groups.  So layersets get counted twice. 
		var infoList=[];
		try{ srcDoc.backgroundLayer;  var i = 0; }catch(e){ var i = 1; }; 
	
	for(i;i<count;i++)
		{ 
	  var newLay = {};
        ref = new ActionReference(); 
        ref.putIndex( charIDToTypeID( 'Lyr ' ), i );
        var desc = executeActionGet(ref);
		// this gets the layer name 
        var layerName = desc.getString(charIDToTypeID( 'Nm  ' ));
		if(layerName.match(/^<\/Layer group/) ) continue;  // removes "/Layer Groups" from the listed output.   (like if ID = "/Layer Group" then skip) 		
// All kinds of other stuff you can get from a layer. 
          newLay.id = desc.getInteger(stringIDToTypeID( 'layerID' ));
		 var getbounds = desc.getObjectValue(stringIDToTypeID('bounds'));
		 buildBounds = []; 
			for (var b = 0; b < 4; b++) 
			{
				buildBounds.push(parseInt(getbounds.getUnitDoubleValue(getbounds.getKey(b))));
			}
		 newLay.bounds = buildBounds;	
          infoList.push(newLay);
   };
return infoList;
};

///////////////////////////////////////////////////////////////////////////////
// Function: deleteByID
// Usage: delete the layer with the supplied action ID
// Input: ActionManagerID of a layer I wish to delete 
// Return: none (deleted layers)
///////////////////////////////////////////////////////////////////////////////
function deleteByID(ID)
{
   var ref = new ActionReference();
   ref.putIdentifier(charIDToTypeID('Lyr '), ID);
   var desc = new ActionDescriptor();
   desc.putReference(charIDToTypeID('null'), ref);
   
   desc.putBoolean(charIDToTypeID('MkVs'), false);
   try {
	   executeAction(stringIDToTypeID( "delete" ), desc, DialogModes.NO); 
	   } catch(e) {} 
}



///////////////////////////////////////////////////////////////////////////////
// Function:  getArtBoards
// Usage: verify that supplied layers (identified by AMid) are artboards.  
// Input: array of AM id's. 
// Return: Return list of AMid of actual artboards.  (removing any layers that are not artboards) 
///////////////////////////////////////////////////////////////////////////////
function getArtBoards(inArray)
{
    var infoList = [];
    
	for(i=0;i<inArray.length;i++)
		{ 
            var obj = {}
            ref = new ActionReference(); 
            ref.putIndex( charIDToTypeID( 'Lyr ' ),  inArray[i]);
            var desc = executeActionGet(ref);
            var Id = desc.getInteger(stringIDToTypeID( 'layerID' ));
            var name =  desc.getString(charIDToTypeID( 'Nm  ' ));
            var isArtboard =desc.getBoolean(stringIDToTypeID('artboardEnabled'));
            if (isArtboard) 
               { 
                   obj.name = name;
                   obj.AMid = Id;
                   infoList.push(obj); 
               }        
          }
    return infoList;
};

///////////////////////////////////////////////////////////////////////////////
// Function: cleanUnseenAB
// Usage: detects overlaping artboards based on the bounds of the supplied artboard (Via AMid) and removes all those that are NOT overlaping.
// Input: Array of layers identified by AMid
// Return: all uninterecting artboards deleted.  
///////////////////////////////////////////////////////////////////////////////
function cleanUnseenAB(inAMid, abArALL)
{
    var overlapLayInfo = getOverlapingLayers(inAMid, abArALL, true);  // true means to invert the function and create array of NOT overalping artboards. 
    for (x=0;x<overlapLayInfo.length;x++)
    {
          deleteByID(overlapLayInfo[x].AMid);
    }
}


///////////////////////////////////////////////////////////////////////////////
// Function: getOverlapingLayers
// Usage: using square bounds,  select all layers that intersect with bounds. (same idea as Auto-Select Group in UI.) 
// Input: LayerID whos bounds you want to get overaping data from.,  an array of all artboard data in document, Boolean if you want to invert results. 
// Return: selected layers  that either overlap or do not overlap layer
///////////////////////////////////////////////////////////////////////////////
function getOverlapingLayers(inLayAMid, abArALL, invert)
{
        for (i=0;i<abArALL.length;i++)
        {
           if  (abArALL[i].AMid == inLayAMid)  var pos = abArALL[i].bounds;     
         }

       var getAllOverlap = []; 
       for(var a in abArALL)
		{
            var horiz = false;
            var vert = false;
			var boundsInfo = (abArALL[a].bounds); 
			var layName = (abArALL[a].name); 
			//if (layName  == curLay) continue; 
				if (boundsInfo[3] >= pos[1]) 
				{
                     if (boundsInfo[1] <= pos[3]) 
                        {
                          var horiz = true
                            }         
				} 
				if (boundsInfo[2] >= pos[0]) 
				{
                     if (boundsInfo[0] <= pos[2]) 
                        {
                          var vert = true
                         }         
				} 
            
        if (!invert) { if ((vert) && (horiz))  getAllOverlap.push(abArALL[a]);  } // to get all layers that DO overlap 
        if (invert) 
        {    
            selectLayerFromAMid(inLayAMid,"removeFromSelection"); // deselect the one you started with. 
            if ((!vert) || (!horiz))  getAllOverlap.push(abArALL[a]) ; }  // to get all layers that DONOT overlap         
          }
      return getAllOverlap
} // end function 


// End Export Artboards To Files.jsx
 